! Compute the mean of an array passed in from C
!
!   x = pointer to the array
!   n = length of the array
!
function mean(x, n)
use iso_c_binding, only: C_PTR, C_DOUBLE, C_INT, c_f_pointer
implicit none

type(C_PTR), value::x
integer(kind=C_INT), value::n
real(kind=C_DOUBLE)::mean

real(kind=C_DOUBLE), dimension(:), pointer::fx

    ! Convert the C pointer of length n to an appropriate
    ! Fortran pointer
    call c_f_pointer(x, fx, [n])
    
    mean = sum(fx)/real(n, C_DOUBLE)
    
end function mean

! Compute the standard deviation of an array passed in from C
!
!   x = pointer to the array
!   n = length of the array
!
function standard_deviation(x, n)
use iso_c_binding, only: C_PTR, C_DOUBLE, C_INT, c_f_pointer
implicit none

type(C_PTR), value::x
integer(kind=C_INT), value::n
real(kind=C_DOUBLE)::standard_deviation

real(kind=C_DOUBLE)::m
real(kind=C_DOUBLE), dimension(:), pointer::fx
real(kind=C_DOUBLE), dimension(:), allocatable::work

    ! Convert the C pointer of length n to an appropriate
    ! Fortran pointer
    call c_f_pointer(x, fx, [n])
    
    ! Allocate a work array
    allocate(work(n))
    
    ! Calculate the mean
    m = sum(fx)/real(n, C_DOUBLE)
    
    ! Calcuate individual terms' differences from mean
    work = fx - m
    
    ! Square the terms
    work = work * work
    
    ! Finish up
    standard_deviation = sqrt(sum(work)/real(n-1, C_DOUBLE))
    
    ! Discard the work array
    deallocate(work)
    
end function standard_deviation
