#ifndef __APLOT_HEADERS__
#define __APLOT_HEADERS__

#ifdef __cplusplus
#define EXTERNC extern "C" 
#else
#define EXTERNC 
#endif

#ifdef __WIN32__
#include <windows.h>
#endif

#ifdef USE_X11
#include <X11/Xlib.h>
#endif

struct plot {
#ifdef __WIN32__
    int id;
    int embedded_id;
    int block;
    volatile int event;
    HANDLE hDrawThread;
    HANDLE hDrawnEvent;
    HANDLE hCloseEvent;
    int x, y, w, h;
#else
#ifdef USE_X11
    int screen;
    Display *display;
    Window window;
    Pixmap buffer;
    struct {
        int x,y,w,h;
    } bSave, bClose, bAbout;
    int barHeight;
#else
#ifdef __APPLE__
    void *plotwindow;
    void *plotdelegate;
#endif
#endif
#endif
    void *pplot;
};

#define APLOT_STYLE_LINE    0
#define APLOT_STYLE_DOT     1
#define APLOT_STYLE_BAR     2
#define APLOT_STYLE_PIXEL   3

EXTERNC struct plot *initialize_plot();
EXTERNC void destroy_plot(struct plot *p);

EXTERNC void draw_plot(struct plot *p);
EXTERNC void display_plot(struct plot *p);

/* Becuase of the Windows architecture, we can handle some interesting async cases */
#ifdef __WIN32__
EXTERNC void display_plot_async(struct plot *p);
EXTERNC void close_plot(struct plot *p);
EXTERNC int save_plot(struct plot *p, const char *filename);

/* The "window" argument is a valid AppGraphics window id */
EXTERNC void embed_plot(struct plot *p, int window, int x, int y, int w, int h);
#endif

EXTERNC void add_dataset(struct plot *p, double *x, double *y, int n);

EXTERNC void set_title(struct plot *p, const char *name);
EXTERNC void set_xlabel(struct plot *p, const char *name);
EXTERNC void set_ylabel(struct plot *p, const char *name);

EXTERNC void set_xscale(struct plot *p, double xmin, double xmax);
EXTERNC void set_yscale(struct plot *p, double ymin, double ymax);
EXTERNC void set_xautoscale(struct plot *p);
EXTERNC void set_yautoscale(struct plot *p);

EXTERNC void set_serieslabel(struct plot *p, int i, const char *name);
EXTERNC void set_seriestype(struct plot *p, int i, int type);
EXTERNC void set_seriescolor(struct plot *p, int i, int r, int g, int b);

#define ABOUT_TEXT  "APlot for Simply Fortran\r\nfrom Approximatrix"

#endif /* __APLOT_HEADERS__ */
