#ifndef _APPGRAPHICS_LEGACY_BGI
#define _APPGRAPHICS_LEGACY_BGI

/* The various graphics drivers */
enum graphics_drivers { DETECT, CGA, MCGA, EGA, EGA64, EGAMONO, IBM8514, HERCMONO,
                        ATT400, VGA, PC3270 };

/* Various modes for each graphics driver */
enum graphics_modes { CGAC0, CGAC1, CGAC2, CGAC3, CGAHI, 
                      MCGAC0 = 0, MCGAC1, MCGAC2, MCGAC3, MCGAMED, MCGAHI,
                      EGALO = 0, EGAHI,
                      EGA64LO = 0, EGA64HI,
                      EGAMONOHI = 3,
                      HERCMONOHI = 0,
                      ATT400C0 = 0, ATT400C1, ATT400C2, ATT400C3, ATT400MED, ATT400HI,
                      VGALO = 0, VGAMED, VGAHI,
                      PC3270HI = 0,
                      IBM8514LO = 0, IBM8514HI };

/* Macros */
#define refreshbgi(l, t, r, b)  refreshrect(l, t, r, b)
#define refreshallbgi( )        refreshall( )
#define setrefreshingbgi(x)     setrefreshing(x)
#define closegraph(id)          closewindow(id)

#define IS_BGI_COLOR(v)     FALSE

#undef COLOR
#define COLOR(r, g, b)      creatergb(r, g, b)

#ifdef __cplusplus
extern "C" {
#endif
                      
/* Legacy BGI-compatible functions */
void getmoderange( int graphdriver, int *lomode, int *himode );
void detectgraph( int *graphdriver, int *graphmode );
char *getdrivername( );
void initgraph( int *graphdriver, int *graphmode, char *pathtodriver );
int installuserdriver( char *name, int *fp );    /* Not available in WinBGI */
int installuserfont( char *name );               /* Not available in WinBGI */
int registerbgidriver( void *driver );           /* Not available in WinBGI */
int registerbgifont( void *font );               /* Not available in WinBGI */                      
unsigned setgraphbufsize( unsigned bufsize );    /* Not available in WinBGI */ 
int getgraphmode( );
int getmaxmode( );
char *getmodename( int mode_number );
void restorecrtmode( );
void setgraphmode( int mode );

void showerrorbox( const TCHAR *msg );

int getmaxcolor( );

#ifdef __cplusplus
}
#endif

#endif /* _APPGRAPHICS_LEGACY_BGI */