#ifndef _APPGRAPHICS_CONSTANTS_HEADERS
#define _APPGRAPHICS_CONSTANTS_HEADERS

#include <windows.h>

/* ---------------------------------------------------------------------------
 *                          Definitions
 * ---------------------------------------------------------------------------
 */
 
 
/* Definitions for the key pad extended keys are added here.  When one
 * of these keys are pressed, getch will return a zero followed by one
 * of these values. 
 */
#define KEY_HOME        71
#define KEY_UP          72
#define KEY_PGUP        73
#define KEY_LEFT        75
#define KEY_CENTER      76
#define KEY_RIGHT       77
#define KEY_END         79
#define KEY_DOWN        80
#define KEY_PGDN        81
#define KEY_INSERT      82
#define KEY_DELETE      83
#define KEY_F1          59
#define KEY_F2          60
#define KEY_F3          61
#define KEY_F4          62
#define KEY_F5          63
#define KEY_F6          64
#define KEY_F7          65
#define KEY_F8          66
#define KEY_F9          67
#define KEY_F10         68
#define KEY_F11         69
#define KEY_F12         70

/* Line thickness settings */
#define NORM_WIDTH      1
#define THICK_WIDTH     3

/* Character Size and Direction */
#define HORIZ_DIR       0
#define VERT_DIR        1

/* Background Drawing Mode */
#define OPAQUE_BACKGROUND       0
#define TRANSPARENT_BACKGROUND  1

/* Constants for closegraph */
#define CURRENT_WINDOW -1
#define ALL_WINDOWS -2
#define NO_CURRENT_WINDOW -3

/* Menu constants */
#define MENU_FOR_WINDOW -1
#define MENU_ERROR      -2

/* Controls constants */
#define CONTROLS_ERROR  -1
#define CONTROLS_BUFFER_TOO_SMALL  -2

/* For Borland-compatible colors */
#define MAXCOLORS       15

/* No mouse event of the current type in getmouseclick */
#define NO_CLICK        -1      

/* For thread waiting */
#define WAIT_INFINITE   -1

/* Message Dialog types */
#define DIALOG_INFO     1
#define DIALOG_WARN     2
#define DIALOG_ERR      3

/* Default window position */
#define DEFAULT_POSITION    -32768

/* Standard colors */
#define BLACK          RGB( 0, 0, 0 )
#define BLUE           RGB( 0, 0, 128)      
#define GREEN          RGB( 0, 128, 0 )       
#define CYAN           RGB( 0, 128, 128 )     
#define RED            RGB( 128, 0, 0 )       
#define MAGENTA        RGB( 128, 0, 128 )     
#define BROWN          RGB( 128, 128, 0 )     
#define LIGHTGRAY      RGB( 192, 192, 192 )   
#define DARKGRAY       RGB( 128, 128, 128 )   
#define LIGHTBLUE      RGB( 128, 128, 255 )   
#define LIGHTGREEN     RGB( 128, 255, 128 )  
#define LIGHTCYAN      RGB( 128, 255, 255 )  
#define LIGHTRED       RGB( 255, 128, 128 )  
#define LIGHTMAGENTA   RGB( 255, 128, 255 )  
#define YELLOW         RGB( 255, 255, 0 ) 
#define WHITE          RGB( 255, 255, 255 ) 

/* System colors */
#define COLOR_WINDOW_BKGD   COLOR_3DFACE

/* Mouse constants */
#define MOUSE_MOVE          WM_MOUSEMOVE
#define MOUSE_LB_DBLCLK     WM_LBUTTONDBLCLK
#define MOUSE_LB_DOWN       WM_LBUTTONDOWN
#define MOUSE_LB_UP         WM_LBUTTONUP
#define MOUSE_MB_DBLCLK     WM_MBUTTONDBLCLK
#define MOUSE_MB_DOWN       WM_MBUTTONDOWN
#define MOUSE_MB_UP         WM_MBUTTONUP
#define MOUSE_RB_DBLCLK     WM_RBUTTONDBLCLK
#define MOUSE_RB_DOWN       WM_RBUTTONDOWN
#define MOUSE_RB_UP         WM_RBUTTONUP 
#define MOUSE_WHEEL         WM_MOUSEWHEEL

/* Scroll bar constants */
#define SCROLL_HORIZONTAL   0
#define SCROLL_VERTICAL     1

/* Cursor contstants */
#define CURSOR_STANDARD     0
#define CURSOR_CROSSHAIR    1
#define CURSOR_IBEAM        2
#define CURSOR_HAND         3
#define CURSOR_HELP         4
#define CURSOR_WAIT         5
#define CURSOR_NO           6
#define CURSOR_SIZE_NS      7
#define CURSOR_SIZE_EW      8
#define CURSOR_SIZE_NWSE    9
#define CURSOR_SIZE_NESW    10
#define CURSOR_COUNT        11

/* The standard line styles */
enum line_styles { SOLID_LINE, 
                   DOTTED_LINE, 
                   CENTER_LINE, 
                   DASHED_LINE, 
                   USERBIT_LINE };
                   
/* The standard fill styles */
enum fill_styles { EMPTY_FILL, 
                   SOLID_FILL, 
                   LINE_FILL, 
                   LTSLASH_FILL, 
                   SLASH_FILL,
                   BKSLASH_FILL, 
                   LTBKSLASH_FILL, 
                   HATCH_FILL, 
                   XHATCH_FILL, 
                   INTERLEAVE_FILL,
                   WIDE_DOT_FILL, 
                   CLOSE_DOT_FILL, 
                   USER_FILL };
                   
/* Borland error messages for the graphics window. */
enum graph_errors { grInvalidVersion = -18, 
                    grInvalidDeviceNum = -15, 
                    grInvalidFontNum,
                    grInvalidFont, 
                    grIOerror, 
                    grError, 
                    grInvalidMode, 
                    grNoFontMem,
                    grFontNotFound, 
                    grNoFloodMem, 
                    grNoScanMem, 
                    grNoLoadMem,
                    grInvalidDriver, 
                    grFileNotFound, 
                    grNotDetected, 
                    grNoInitGraph,
                    grOk };

/* Write modes */
enum putimage_ops{ COPY_PUT, 
                   XOR_PUT, 
                   OR_PUT, 
                   AND_PUT, 
                   NOT_PUT };

/* Text Modes */
enum horiz      { LEFT_TEXT, 
                  CENTER_TEXT, 
                  RIGHT_TEXT };
                  
enum vertical   { BOTTOM_TEXT, 
                  VCENTER_TEXT, 
                  TOP_TEXT }; 
                  
enum font_names { DEFAULT_FONT, 
                  SANS_SERIF_FONT, 
                  SERIF_FONT,
                  CURSIVE_FONT,
                  BOLD_SANS_SERIF_FONT,
                  BOLD_SERIF_FONT,
                  MONOSPACE_FONT,
                  WINDOWS_FONT,
                  SYMBOLS_FONT };

#endif  /* _APPGRAPHICS_CONSTANTS_HEADERS */